/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.ender;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import owmii.powah.Powah;
import owmii.powah.block.Tier;
import owmii.powah.block.ender.EnderGateTile;
import owmii.powah.config.v2.types.EnderConfig;
import owmii.powah.inventory.EnderCellContainer;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyBlock;
import owmii.powah.lib.block.AbstractTileEntity;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.logistics.inventory.AbstractContainer;

public class EnderGateBlock
extends AbstractEnergyBlock<EnderConfig, EnderGateBlock> {
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public EnderGateBlock(BlockBehaviour.Properties properties, Tier variant) {
        super(properties, variant);
    }

    @Override
    public EnderConfig getConfig() {
        return Powah.config().devices.ender_gates;
    }

    @Override
    public EnergyBlockItem getBlockItem(Item.Properties properties, @Nullable CreativeModeTab group) {
        return super.getBlockItem(properties, group);
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)BlockStateProperties.f_61372_));
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnderGateTile(pos, state, (Tier)this.variant);
    }

    @Override
    @Nullable
    public AbstractContainer getContainer(int id, Inventory inventory, AbstractTileEntity te, BlockHitResult result) {
        if (te instanceof EnderGateTile) {
            return new EnderCellContainer(id, inventory, (EnderGateTile)te);
        }
        return null;
    }

    @Override
    protected boolean checkValidEnergySide() {
        return true;
    }

    @Override
    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.ALL;
    }

    static {
        SHAPES.put(Direction.UP, EnderGateBlock.box(6.0, 15.5, 6.0, 10.0, 16.0, 10.0));
        SHAPES.put(Direction.DOWN, EnderGateBlock.box(6.0, 0.0, 6.0, 10.0, 0.5, 10.0));
        SHAPES.put(Direction.NORTH, EnderGateBlock.box(6.0, 6.0, 0.0, 10.0, 10.0, 0.5));
        SHAPES.put(Direction.SOUTH, EnderGateBlock.box(6.0, 6.0, 15.5, 10.0, 10.0, 16.0));
        SHAPES.put(Direction.EAST, EnderGateBlock.box(15.5, 6.0, 6.0, 16.0, 10.0, 10.0));
        SHAPES.put(Direction.WEST, EnderGateBlock.box(0.0, 6.0, 6.0, 0.5, 10.0, 10.0));
    }
}

